/* =====================================================
   ISF 10+2 Simulator - Export Functions
   JSON, Excel, CSV Export Functionality
   ===================================================== */

// Export to JSON
function downloadJSON() {
    if (!isfData || Object.keys(isfData).length === 0) {
        alert('Please validate the form first before exporting.');
        return;
    }
    
    const jsonString = JSON.stringify(isfData, null, 2);
    const blob = new Blob([jsonString], { type: 'application/json' });
    const url = URL.createObjectURL(blob);
    const filename = `ISF_${isfData.vessel_information.bill_of_lading}_${getTimestamp()}.json`;
    
    downloadFile(url, filename);
    trackAnalytics('export', 'JSON Export', { bol: isfData.vessel_information.bill_of_lading });
}

// Export to CSV
function downloadCSV() {
    if (!isfData || Object.keys(isfData).length === 0) {
        alert('Please validate the form first before exporting.');
        return;
    }
    
    let csv = 'ISF 10+2 Data Export - Aduanalibre.com Educational Tool\n';
    csv += `Generated: ${new Date().toLocaleString()}\n`;
    csv += 'EDUCATIONAL ONLY - NOT TRANSMITTED TO CBP\n\n';
    
    // Vessel Information
    csv += 'VESSEL INFORMATION\n';
    csv += 'Field,Value\n';
    csv += `Vessel Name,${isfData.vessel_information.vessel_name}\n`;
    csv += `Bill of Lading,${isfData.vessel_information.bill_of_lading}\n`;
    csv += `Loading Date,${isfData.vessel_information.loading_date}\n`;
    csv += `Estimated Arrival,${isfData.vessel_information.estimated_arrival_date}\n`;
    csv += `Port of Unlading,${isfData.vessel_information.port_of_unlading}\n\n`;
    
    // Element 1: Seller
    csv += 'ELEMENT 1: SELLER\n';
    csv += 'Field,Value\n';
    csv += `Seller Name,${isfData.isf_elements.element_1_seller.name}\n`;
    csv += `Address,${isfData.isf_elements.element_1_seller.address}\n`;
    csv += `City,${isfData.isf_elements.element_1_seller.city}\n`;
    csv += `State,${isfData.isf_elements.element_1_seller.state}\n`;
    csv += `Country,${isfData.isf_elements.element_1_seller.country}\n\n`;
    
    // Element 2: Buyer
    csv += 'ELEMENT 2: BUYER\n';
    csv += 'Field,Value\n';
    csv += `Buyer Name,${isfData.isf_elements.element_2_buyer.name}\n`;
    csv += `Address,${isfData.isf_elements.element_2_buyer.address}\n`;
    csv += `City,${isfData.isf_elements.element_2_buyer.city}\n`;
    csv += `State,${isfData.isf_elements.element_2_buyer.state}\n`;
    csv += `ZIP,${isfData.isf_elements.element_2_buyer.zip}\n\n`;
    
    // Element 3: Importer
    csv += 'ELEMENT 3: IMPORTER OF RECORD\n';
    csv += 'Field,Value\n';
    csv += `Importer Number,${isfData.isf_elements.element_3_importer.number}\n`;
    csv += `Importer Name,${isfData.isf_elements.element_3_importer.name}\n\n`;
    
    // Element 4: Consignee
    csv += 'ELEMENT 4: CONSIGNEE\n';
    csv += 'Field,Value\n';
    csv += `Consignee Number,${isfData.isf_elements.element_4_consignee.number}\n`;
    csv += `Consignee Name,${isfData.isf_elements.element_4_consignee.name}\n\n`;
    
    // Element 5: Manufacturer
    csv += 'ELEMENT 5: MANUFACTURER (Flexible)\n';
    csv += 'Field,Value\n';
    csv += `Manufacturer Name,${isfData.isf_elements.element_5_manufacturer.name}\n`;
    csv += `Address,${isfData.isf_elements.element_5_manufacturer.address}\n`;
    csv += `Country,${isfData.isf_elements.element_5_manufacturer.country}\n\n`;
    
    // Element 6: Ship To
    csv += 'ELEMENT 6: SHIP TO PARTY (Flexible)\n';
    csv += 'Field,Value\n';
    csv += `Ship To Name,${isfData.isf_elements.element_6_ship_to.name}\n`;
    csv += `Address,${isfData.isf_elements.element_6_ship_to.address}\n`;
    csv += `City,${isfData.isf_elements.element_6_ship_to.city}\n`;
    csv += `State,${isfData.isf_elements.element_6_ship_to.state}\n`;
    csv += `ZIP,${isfData.isf_elements.element_6_ship_to.zip}\n\n`;
    
    // Element 7: Country of Origin
    csv += 'ELEMENT 7: COUNTRY OF ORIGIN (Flexible)\n';
    csv += 'Field,Value\n';
    csv += `Country,${isfData.isf_elements.element_7_country_of_origin.country}\n\n`;
    
    // Element 8: HTS
    csv += 'ELEMENT 8: HTS NUMBER (Flexible)\n';
    csv += 'Field,Value\n';
    csv += `HTS Code,${isfData.isf_elements.element_8_hts.code}\n`;
    csv += `Description,${isfData.isf_elements.element_8_hts.description}\n\n`;
    
    // Element 9: Stuffing Location
    csv += 'ELEMENT 9: CONTAINER STUFFING LOCATION\n';
    csv += 'Field,Value\n';
    csv += `Location,${isfData.isf_elements.element_9_stuffing_location.location}\n`;
    csv += `Timing,${isfData.isf_elements.element_9_stuffing_location.timing}\n\n`;
    
    // Element 10: Consolidator
    csv += 'ELEMENT 10: CONSOLIDATOR\n';
    csv += 'Field,Value\n';
    csv += `Name,${isfData.isf_elements.element_10_consolidator.name}\n`;
    csv += `Address,${isfData.isf_elements.element_10_consolidator.address}\n`;
    csv += `Timing,${isfData.isf_elements.element_10_consolidator.timing}\n\n`;
    
    // Compliance Info
    csv += 'COMPLIANCE INFORMATION\n';
    csv += 'Item,Detail\n';
    csv += `Filing Deadline,${isfData.compliance.filing_deadline}\n`;
    csv += `Update Deadline,${isfData.compliance.update_deadline}\n`;
    csv += `Penalty,${isfData.compliance.penalty_for_violation}\n`;
    csv += `Responsible Party,${isfData.compliance.responsible_party}\n\n`;
    
    const blob = new Blob([csv], { type: 'text/csv' });
    const url = URL.createObjectURL(blob);
    const filename = `ISF_${isfData.vessel_information.bill_of_lading}_${getTimestamp()}.csv`;
    
    downloadFile(url, filename);
    trackAnalytics('export', 'CSV Export', { bol: isfData.vessel_information.bill_of_lading });
}

// Export to Excel (HTML table format that Excel can open)
function downloadExcel() {
    if (!isfData || Object.keys(isfData).length === 0) {
        alert('Please validate the form first before exporting.');
        return;
    }
    
    let html = `
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; }
        table { border-collapse: collapse; width: 100%; margin-bottom: 20px; }
        th, td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        th { background-color: #0066cc; color: white; font-weight: bold; }
        .section-header { background-color: #f0f0f0; font-weight: bold; }
        .warning { background-color: #fff3cd; padding: 15px; margin: 20px 0; border-left: 4px solid #ffc107; }
        .flexible { background-color: #fffbf0; }
        h1 { color: #0066cc; }
        h2 { color: #333; border-bottom: 2px solid #0066cc; padding-bottom: 5px; }
    </style>
</head>
<body>
    <h1>ISF 10+2 Data Export</h1>
    <p><strong>Generated by:</strong> Aduanalibre.com Educational Tool</p>
    <p><strong>Generated at:</strong> ${new Date().toLocaleString()}</p>
    
    <div class="warning">
        <strong>⚠️ EDUCATIONAL TOOL ONLY</strong><br>
        This data has NOT been transmitted to U.S. Customs (CBP).<br>
        You must file through ACE Portal, certified software, or a licensed customs broker.
    </div>
    
    <h2>Vessel Information</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Vessel Name</td><td>${isfData.vessel_information.vessel_name}</td></tr>
        <tr><td>Bill of Lading</td><td>${isfData.vessel_information.bill_of_lading}</td></tr>
        <tr><td>Loading Date</td><td>${isfData.vessel_information.loading_date}</td></tr>
        <tr><td>Estimated Arrival Date</td><td>${isfData.vessel_information.estimated_arrival_date}</td></tr>
        <tr><td>Port of Unlading</td><td>${isfData.vessel_information.port_of_unlading}</td></tr>
    </table>
    
    <h2>Element 1: Seller (Vendor)</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Seller Name</td><td>${isfData.isf_elements.element_1_seller.name}</td></tr>
        <tr><td>Address</td><td>${isfData.isf_elements.element_1_seller.address}</td></tr>
        <tr><td>City</td><td>${isfData.isf_elements.element_1_seller.city}</td></tr>
        <tr><td>State/Province</td><td>${isfData.isf_elements.element_1_seller.state}</td></tr>
        <tr><td>Country</td><td>${isfData.isf_elements.element_1_seller.country}</td></tr>
    </table>
    
    <h2>Element 2: Buyer (Owner)</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Buyer Name</td><td>${isfData.isf_elements.element_2_buyer.name}</td></tr>
        <tr><td>Address</td><td>${isfData.isf_elements.element_2_buyer.address}</td></tr>
        <tr><td>City</td><td>${isfData.isf_elements.element_2_buyer.city}</td></tr>
        <tr><td>State</td><td>${isfData.isf_elements.element_2_buyer.state}</td></tr>
        <tr><td>ZIP Code</td><td>${isfData.isf_elements.element_2_buyer.zip}</td></tr>
    </table>
    
    <h2>Element 3: Importer of Record Number</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Importer Number (IRS/EIN)</td><td>${isfData.isf_elements.element_3_importer.number}</td></tr>
        <tr><td>Importer Name</td><td>${isfData.isf_elements.element_3_importer.name}</td></tr>
    </table>
    
    <h2>Element 4: Consignee Number</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Consignee Number (IRS/EIN)</td><td>${isfData.isf_elements.element_4_consignee.number}</td></tr>
        <tr><td>Consignee Name</td><td>${isfData.isf_elements.element_4_consignee.name}</td></tr>
    </table>
    
    <h2>Element 5: Manufacturer/Supplier <span style="color: #ffc107;">★ Flexible</span></h2>
    <table class="flexible">
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Manufacturer Name</td><td>${isfData.isf_elements.element_5_manufacturer.name}</td></tr>
        <tr><td>Address</td><td>${isfData.isf_elements.element_5_manufacturer.address}</td></tr>
        <tr><td>Country</td><td>${isfData.isf_elements.element_5_manufacturer.country}</td></tr>
        <tr><td colspan="2" style="font-style: italic; background-color: #fffbf0;">Note: ${isfData.isf_elements.element_5_manufacturer.note}</td></tr>
    </table>
    
    <h2>Element 6: Ship To Party <span style="color: #ffc107;">★ Flexible</span></h2>
    <table class="flexible">
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Ship To Name</td><td>${isfData.isf_elements.element_6_ship_to.name}</td></tr>
        <tr><td>Address</td><td>${isfData.isf_elements.element_6_ship_to.address}</td></tr>
        <tr><td>City</td><td>${isfData.isf_elements.element_6_ship_to.city}</td></tr>
        <tr><td>State</td><td>${isfData.isf_elements.element_6_ship_to.state}</td></tr>
        <tr><td>ZIP Code</td><td>${isfData.isf_elements.element_6_ship_to.zip}</td></tr>
        <tr><td colspan="2" style="font-style: italic; background-color: #fffbf0;">Note: ${isfData.isf_elements.element_6_ship_to.note}</td></tr>
    </table>
    
    <h2>Element 7: Country of Origin <span style="color: #ffc107;">★ Flexible</span></h2>
    <table class="flexible">
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Country of Origin</td><td>${isfData.isf_elements.element_7_country_of_origin.country}</td></tr>
        <tr><td colspan="2" style="font-style: italic; background-color: #fffbf0;">Note: ${isfData.isf_elements.element_7_country_of_origin.note}</td></tr>
    </table>
    
    <h2>Element 8: Commodity HTS Number <span style="color: #ffc107;">★ Flexible</span></h2>
    <table class="flexible">
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>HTS Code</td><td>${isfData.isf_elements.element_8_hts.code}</td></tr>
        <tr><td>Commodity Description</td><td>${isfData.isf_elements.element_8_hts.description}</td></tr>
        <tr><td colspan="2" style="font-style: italic; background-color: #fffbf0;">Note: ${isfData.isf_elements.element_8_hts.note}</td></tr>
    </table>
    
    <h2>Element 9: Container Stuffing Location</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Stuffing Location</td><td>${isfData.isf_elements.element_9_stuffing_location.location}</td></tr>
        <tr><td>Timing Requirement</td><td>${isfData.isf_elements.element_9_stuffing_location.timing}</td></tr>
        <tr><td colspan="2" style="font-style: italic; background-color: #f0f9ff;">Note: ${isfData.isf_elements.element_9_stuffing_location.note}</td></tr>
    </table>
    
    <h2>Element 10: Consolidator (Stuffer)</h2>
    <table>
        <tr><th>Field</th><th>Value</th></tr>
        <tr><td>Consolidator Name</td><td>${isfData.isf_elements.element_10_consolidator.name}</td></tr>
        <tr><td>Consolidator Address</td><td>${isfData.isf_elements.element_10_consolidator.address}</td></tr>
        <tr><td>Timing Requirement</td><td>${isfData.isf_elements.element_10_consolidator.timing}</td></tr>
        <tr><td colspan="2" style="font-style: italic; background-color: #f0f9ff;">Note: ${isfData.isf_elements.element_10_consolidator.note}</td></tr>
    </table>
    
    <h2>Compliance Information</h2>
    <table>
        <tr><th>Compliance Item</th><th>Detail</th></tr>
        <tr><td>Filing Deadline</td><td>${isfData.compliance.filing_deadline}</td></tr>
        <tr><td>Update Deadline</td><td>${isfData.compliance.update_deadline}</td></tr>
        <tr><td>Penalty for Violation</td><td>${isfData.compliance.penalty_for_violation}</td></tr>
        <tr><td>Responsible Party</td><td>${isfData.compliance.responsible_party}</td></tr>
    </table>
    
    <h2>Next Steps (Official Filing)</h2>
    <table>
        <tr><th>Step</th><th>Action Required</th></tr>
        <tr><td>1</td><td>${isfData.next_steps.step_1}</td></tr>
        <tr><td>2</td><td>${isfData.next_steps.step_2}</td></tr>
        <tr><td>3</td><td>${isfData.next_steps.step_3}</td></tr>
        <tr><td>4</td><td>${isfData.next_steps.step_4}</td></tr>
        <tr><td>5</td><td>${isfData.next_steps.step_5}</td></tr>
    </table>
    
    <div style="margin-top: 40px; padding: 20px; background-color: #f8f9fa; border-top: 3px solid #0066cc;">
        <p><strong>Aduanalibre.com</strong> - El primer buscador de productos y servicios de zonas francas</p>
        <p style="font-size: 12px; color: #666;">
            This is an educational tool. For official ISF filing, please contact:<br>
            • Licensed Customs Broker<br>
            • Certified ISF filing platform (eezyimport, CustomsCity, Magaya, etc.)<br>
            • ACE Portal (if filing < 12 ISF per year)
        </p>
    </div>
</body>
</html>`;
    
    const blob = new Blob([html], { type: 'application/vnd.ms-excel' });
    const url = URL.createObjectURL(blob);
    const filename = `ISF_${isfData.vessel_information.bill_of_lading}_${getTimestamp()}.xls`;
    
    downloadFile(url, filename);
    trackAnalytics('export', 'Excel Export', { bol: isfData.vessel_information.bill_of_lading });
}

// Helper: Download file
function downloadFile(url, filename) {
    const a = document.createElement('a');
    a.href = url;
    a.download = filename;
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
    
    // Show success feedback
    showDownloadSuccess(filename);
}

// Helper: Get timestamp for filename
function getTimestamp() {
    const now = new Date();
    return now.toISOString().replace(/[:.]/g, '-').slice(0, 19);
}

// Show download success message
function showDownloadSuccess(filename) {
    const message = document.createElement('div');
    message.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: #28a745;
        color: white;
        padding: 20px 30px;
        border-radius: 8px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        z-index: 10001;
        animation: slideInRight 0.3s ease;
    `;
    message.innerHTML = `
        <i class="fas fa-check-circle"></i> 
        <strong>Downloaded!</strong><br>
        <small>${filename}</small>
    `;
    
    document.body.appendChild(message);
    
    setTimeout(() => {
        message.style.animation = 'slideOutRight 0.3s ease';
        setTimeout(() => message.remove(), 300);
    }, 3000);
}

// Add animations
const style = document.createElement('style');
style.textContent = `
    @keyframes slideInRight {
        from { transform: translateX(400px); opacity: 0; }
        to { transform: translateX(0); opacity: 1; }
    }
    @keyframes slideOutRight {
        from { transform: translateX(0); opacity: 1; }
        to { transform: translateX(400px); opacity: 0; }
    }
`;
document.head.appendChild(style);
