/* =====================================================
   ISF 10+2 Simulator - Help System
   Contextual help for all ISF data elements
   ===================================================== */

const helpContent = {
    vessel_name: {
        title: 'Vessel Name',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The name of the ocean vessel (ship) carrying your cargo to the United States.</p>
            
            <p><strong>Examples:</strong></p>
            <ul>
                <li>MSC OSCAR</li>
                <li>EVER GIVEN</li>
                <li>MAERSK ESSEX</li>
            </ul>
            
            <p><strong>Where to find it:</strong></p>
            <ul>
                <li>✅ Bill of Lading</li>
                <li>✅ Booking confirmation</li>
                <li>✅ Shipping line documentation</li>
            </ul>
            
            <p class="text-danger"><strong>Important:</strong> Must match exactly as shown on the Bill of Lading.</p>
        `
    },
    
    bill_of_lading: {
        title: 'Bill of Lading Number',
        content: `
            <p><strong>What is it?</strong></p>
            <p>A unique number assigned by the carrier to identify your specific shipment.</p>
            
            <p><strong>Format examples:</strong></p>
            <ul>
                <li>MAEU1234567890 (Maersk format)</li>
                <li>MSCU1234567 (MSC format)</li>
                <li>EGLV123456789012 (Evergreen format)</li>
            </ul>
            
            <p><strong>Where to find it:</strong></p>
            <ul>
                <li>✅ Master Bill of Lading (MBL)</li>
                <li>✅ House Bill of Lading (HBL)</li>
                <li>✅ Freight forwarder documentation</li>
            </ul>
            
            <p class="text-warning"><strong>Note:</strong> For LCL shipments, you may need both MBL and HBL numbers.</p>
        `
    },
    
    loading_date: {
        title: 'Loading Date',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The date when your cargo will be (or was) loaded onto the vessel at the foreign port.</p>
            
            <p><strong>⏰ Critical Timing:</strong></p>
            <div class="alert alert-danger">
                <strong>ISF MUST be filed 24 hours BEFORE this date!</strong>
            </div>
            
            <p><strong>Example Timeline:</strong></p>
            <ul>
                <li>Day -2: ISF filed (at least 24 hrs before loading)</li>
                <li>Day 0: Cargo loaded on vessel ← This date</li>
                <li>Day 14: Vessel arrives in USA</li>
            </ul>
            
            <p class="text-danger"><strong>Penalty:</strong> Filing after this deadline = $5,000 fine</p>
        `
    },
    
    arrival_date: {
        title: 'Estimated Arrival Date',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The estimated date when the vessel will arrive at the U.S. port.</p>
            
            <p><strong>⏰ Update Deadline:</strong></p>
            <div class="alert alert-warning">
                Elements 5-10 must be updated (if needed) 24 hours before this date!
            </div>
            
            <p><strong>Where to find it:</strong></p>
            <ul>
                <li>✅ Carrier's vessel schedule</li>
                <li>✅ Bill of Lading</li>
                <li>✅ Freight forwarder updates</li>
                <li>✅ Vessel tracking websites</li>
            </ul>
            
            <p><strong>Note:</strong> This is an <em>estimate</em>. Actual arrival may vary due to weather, port congestion, etc.</p>
        `
    },
    
    port_unlading: {
        title: 'Port of Unlading',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The first U.S. port where your cargo will be unloaded from the vessel.</p>
            
            <p><strong>Common U.S. Ports:</strong></p>
            <ul>
                <li>Los Angeles, CA</li>
                <li>Long Beach, CA</li>
                <li>New York/New Jersey</li>
                <li>Savannah, GA</li>
                <li>Houston, TX</li>
                <li>Seattle, WA</li>
            </ul>
            
            <p><strong>Important:</strong></p>
            <ul>
                <li>✅ Must be a U.S. port</li>
                <li>✅ First discharge port, not final destination</li>
                <li>✅ Even if cargo goes inland by truck later</li>
            </ul>
        `
    },
    
    seller: {
        title: 'Element 1: Seller (Vendor)',
        content: `
            <p><strong>Who is it?</strong></p>
            <p>The last known party who sold the goods for export to the United States.</p>
            
            <p><strong>This could be:</strong></p>
            <ul>
                <li>✅ Manufacturer (if you buy directly)</li>
                <li>✅ Wholesaler</li>
                <li>✅ Trading company</li>
                <li>✅ Distributor</li>
            </ul>
            
            <p><strong>NOT the seller:</strong></p>
            <ul>
                <li>❌ Freight forwarder</li>
                <li>❌ Customs broker</li>
                <li>❌ Shipping line</li>
            </ul>
            
            <p><strong>Required information:</strong></p>
            <ul>
                <li>✅ Full legal name</li>
                <li>✅ Complete address</li>
                <li>✅ City and country</li>
            </ul>
            
            <p class="text-warning"><strong>Tip:</strong> Check your purchase order or commercial invoice for seller details.</p>
        `
    },
    
    buyer: {
        title: 'Element 2: Buyer (Owner)',
        content: `
            <p><strong>Who is it?</strong></p>
            <p>The last known party who purchased the goods for import into the United States.</p>
            
            <p><strong>Usually:</strong></p>
            <ul>
                <li>✅ Your company (if you're the importer)</li>
                <li>✅ The entity that bought from the foreign seller</li>
            </ul>
            
            <p><strong>Key point:</strong></p>
            <div class="alert alert-info">
                The buyer is typically <strong>NOT the ultimate consignee</strong>. If you buy goods and then resell them domestically, <strong>you</strong> are the buyer for ISF purposes, not your customer.
            </div>
            
            <p><strong>Required information:</strong></p>
            <ul>
                <li>✅ Full legal business name</li>
                <li>✅ Complete U.S. address</li>
                <li>✅ City, State, ZIP</li>
            </ul>
        `
    },
    
    importer_number: {
        title: 'Element 3: Importer of Record Number',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The IRS/EIN number (or SSN for individuals) of the party liable for payment of duties and taxes.</p>
            
            <p><strong>Format:</strong></p>
            <div class="alert alert-info">
                <strong>XX-XXXXXXX</strong> (e.g., 12-3456789)
            </div>
            
            <p><strong>Who is the Importer of Record?</strong></p>
            <ul>
                <li>✅ The party that owns the goods at time of import</li>
                <li>✅ Legally responsible for CBP duties and taxes</li>
                <li>✅ Must have ISF Bond ($10,000 minimum)</li>
            </ul>
            
            <p><strong>Types of numbers accepted:</strong></p>
            <ul>
                <li>IRS Number (Tax ID)</li>
                <li>EIN (Employer Identification Number)</li>
                <li>SSN (for individuals - not recommended)</li>
                <li>CBP-assigned number</li>
            </ul>
            
            <p class="text-danger"><strong>Critical:</strong> This number must match your customs bond.</p>
        `
    },
    
    consignee_number: {
        title: 'Element 4: Consignee Number',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The IRS/EIN number of the party to whom the goods will be delivered in the U.S.</p>
            
            <p><strong>Consignee vs Importer:</strong></p>
            <table class="table table-bordered">
                <tr>
                    <th>Importer of Record</th>
                    <th>Consignee</th>
                </tr>
                <tr>
                    <td>Legally responsible</td>
                    <td>Receives the goods</td>
                </tr>
                <tr>
                    <td>Pays duties/taxes</td>
                    <td>May be a warehouse or customer</td>
                </tr>
            </table>
            
            <p><strong>Common scenarios:</strong></p>
            <ul>
                <li><strong>Direct import:</strong> Importer = Consignee (same number)</li>
                <li><strong>For resale:</strong> Importer = your company, Consignee = your warehouse</li>
                <li><strong>Drop shipping:</strong> Importer = your company, Consignee = end customer</li>
            </ul>
            
            <p class="text-warning"><strong>Tip:</strong> If importing to your own facility, use your company's EIN for both Importer and Consignee.</p>
        `
    },
    
    manufacturer: {
        title: 'Element 5: Manufacturer/Supplier ★ FLEXIBLE',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The name and address of the entity that last manufactured, assembled, produced, or grew the goods.</p>
            
            <div class="alert alert-warning">
                <strong>★ FLEXIBLE ELEMENT</strong><br>
                Can be filed with "best available information" initially, then updated before vessel arrival.
            </div>
            
            <p><strong>Examples:</strong></p>
            <ul>
                <li>✅ Factory that produced the goods</li>
                <li>✅ Farm that grew the agricultural products</li>
                <li>✅ Facility that assembled the final product</li>
            </ul>
            
            <p><strong>If multiple manufacturers:</strong></p>
            <ul>
                <li>Option 1: List the primary manufacturer</li>
                <li>Option 2: Provide multiple manufacturers (if shipment has various origins)</li>
                <li>Option 3: Use "MULTIPLE" with country if specific names unknown initially</li>
            </ul>
            
            <p><strong>⏰ Timeline:</strong></p>
            <ul>
                <li>Initial filing: "Best available" info is OK</li>
                <li>Before arrival: Must update with accurate info</li>
            </ul>
        `
    },
    
    ship_to: {
        title: 'Element 6: Ship To Party ★ FLEXIBLE',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The first deliver-to party scheduled to receive the goods <strong>after release</strong> from customs custody in the U.S.</p>
            
            <div class="alert alert-warning">
                <strong>★ FLEXIBLE ELEMENT</strong><br>
                Can be updated before vessel arrival if delivery plans change.
            </div>
            
            <p><strong>This could be:</strong></p>
            <ul>
                <li>✅ Your warehouse</li>
                <li>✅ Distribution center</li>
                <li>✅ Third-party logistics (3PL) facility</li>
                <li>✅ Final customer (for drop-ship)</li>
            </ul>
            
            <p><strong>Important clarifications:</strong></p>
            <ul>
                <li>❌ NOT the port or terminal</li>
                <li>❌ NOT the freight forwarder's office</li>
                <li>✅ The actual inland destination address</li>
            </ul>
            
            <p><strong>Example:</strong></p>
            <div class="alert alert-info">
                If goods arrive at Port of LA but will be trucked to a warehouse in Las Vegas, the Ship To Party is the Las Vegas warehouse.
            </div>
        `
    },
    
    country_origin: {
        title: 'Element 7: Country of Origin ★ FLEXIBLE',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The country where the goods were grown, produced, or manufactured.</p>
            
            <div class="alert alert-warning">
                <strong>★ FLEXIBLE ELEMENT</strong><br>
                Can be filed with reasonable assumption initially, confirmed before arrival.
            </div>
            
            <p><strong>Determining Country of Origin:</strong></p>
            <ul>
                <li><strong>Agricultural:</strong> Where grown/harvested</li>
                <li><strong>Manufactured:</strong> Where last substantially transformed</li>
                <li><strong>Assembled:</strong> Where final assembly occurred</li>
            </ul>
            
            <p><strong>Complex scenarios:</strong></p>
            <div class="alert alert-info">
                <strong>Example:</strong> Fabric from India, sewn into shirts in Vietnam → Country of Origin = Vietnam (substantial transformation)
            </div>
            
            <p><strong>Why it matters:</strong></p>
            <ul>
                <li>✅ Determines duty rates</li>
                <li>✅ Free Trade Agreement eligibility</li>
                <li>✅ Trade sanctions/restrictions</li>
                <li>✅ Section 301 additional duties</li>
            </ul>
            
            <p class="text-danger"><strong>Critical:</strong> Country of Origin affects your total landed cost. Get this right!</p>
        `
    },
    
    hts_number: {
        title: 'Element 8: HTS Number ★ FLEXIBLE',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The Harmonized Tariff Schedule classification code for your goods.</p>
            
            <div class="alert alert-warning">
                <strong>★ FLEXIBLE ELEMENT</strong><br>
                Minimum 6 digits required at filing. Can refine to full 10 digits before arrival.
            </div>
            
            <p><strong>Format:</strong></p>
            <ul>
                <li><strong>Initial ISF:</strong> Minimum 6 digits (XXXX.XX)</li>
                <li><strong>Before arrival:</strong> Full 10 digits (XXXX.XX.XXXX)</li>
            </ul>
            
            <p><strong>Why it matters:</strong></p>
            <ul>
                <li>💰 Determines duty rate (0% - 35%+)</li>
                <li>📋 May require special permits/licenses</li>
                <li>🔍 Determines CBP inspection priority</li>
                <li>📊 Statistical tracking</li>
            </ul>
            
            <p><strong>How to find your HTS code:</strong></p>
            <ul>
                <li><a href="https://hts.usitc.gov" target="_blank">https://hts.usitc.gov</a> (Official U.S. database)</li>
                <li>Ask your customs broker</li>
                <li>Check similar products' classifications</li>
            </ul>
            
            <p class="text-danger"><strong>Warning:</strong> Wrong HTS = Wrong duty rate = Penalties. When in doubt, consult a customs broker!</p>
        `
    },
    
    stuffing_location: {
        title: 'Element 9: Container Stuffing Location',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The physical address where your goods were stuffed into the shipping container.</p>
            
            <div class="alert alert-info">
                <strong>⏰ TIMING FLEXIBLE</strong><br>
                Required 24 hours before vessel <strong>ARRIVAL</strong> at U.S. port (not loading date).
            </div>
            
            <p><strong>This could be:</strong></p>
            <ul>
                <li>✅ Factory/manufacturer location (if container stuffed there)</li>
                <li>✅ Consolidation warehouse</li>
                <li>✅ Container freight station (CFS)</li>
                <li>✅ Port facility</li>
            </ul>
            
            <p><strong>Why CBP needs this:</strong></p>
            <ul>
                <li>🔒 Security screening</li>
                <li>🎯 Risk assessment</li>
                <li>📍 Supply chain transparency</li>
            </ul>
            
            <p><strong>Example Timeline:</strong></p>
            <ul>
                <li>Day 1: Container stuffed in Shenzhen, China ← This location</li>
                <li>Day 3: Container loaded on vessel</li>
                <li>Day 17: Vessel arrives in LA</li>
                <li>Day 16: Must have this data filed (24 hrs before arrival)</li>
            </ul>
        `
    },
    
    consolidator: {
        title: 'Element 10: Consolidator (Stuffer)',
        content: `
            <p><strong>What is it?</strong></p>
            <p>The name and address of the party who stuffed (loaded) the container or arranged for stuffing.</p>
            
            <div class="alert alert-info">
                <strong>⏰ TIMING FLEXIBLE</strong><br>
                Required 24 hours before vessel <strong>ARRIVAL</strong> at U.S. port.
            </div>
            
            <p><strong>This could be:</strong></p>
            <ul>
                <li>✅ Non-Vessel Operating Common Carrier (NVOCC)</li>
                <li>✅ Freight forwarder</li>
                <li>✅ Consolidation warehouse operator</li>
                <li>✅ The seller/manufacturer (if they stuffed it)</li>
            </ul>
            
            <p><strong>Consolidator vs Stuffing Location:</strong></p>
            <table class="table table-bordered">
                <tr>
                    <th>Stuffing Location</th>
                    <th>Consolidator</th>
                </tr>
                <tr>
                    <td>WHERE it was stuffed</td>
                    <td>WHO stuffed it</td>
                </tr>
                <tr>
                    <td>Physical address</td>
                    <td>Company name</td>
                </tr>
            </table>
            
            <p><strong>For FCL (Full Container Load):</strong></p>
            <ul>
                <li>If seller stuffed: Seller = Consolidator</li>
                <li>If manufacturer stuffed: Manufacturer = Consolidator</li>
            </ul>
            
            <p><strong>For LCL (Less than Container Load):</strong></p>
            <ul>
                <li>Usually: Freight forwarder or NVOCC = Consolidator</li>
            </ul>
        `
    }
};

// Show help modal
function showHelp(fieldId) {
    const help = helpContent[fieldId];
    
    if (!help) {
        console.error(`No help content found for: ${fieldId}`);
        return;
    }
    
    // Get modal elements
    const modal = document.getElementById('helpModal');
    const modalTitle = document.getElementById('helpModalTitle');
    const modalContent = document.getElementById('helpModalContent');
    
    // Set content
    modalTitle.textContent = help.title;
    modalContent.innerHTML = help.content;
    
    // Show modal using Bootstrap
    const bsModal = new bootstrap.Modal(modal);
    bsModal.show();
    
    // Track analytics
    trackAnalytics('help_opened', `Help: ${help.title}`);
}

// Export for use in other scripts
if (typeof module !== 'undefined' && module.exports) {
    module.exports = { helpContent, showHelp };
}
